/*
 * Decompiled with CFR 0.152.
 */
package skeletonapplet;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ExtendedLoader
extends SecureClassLoader {
    protected ProtectionDomain myDomain;
    protected Set skeletonIndex = new HashSet();
    protected List jarFiles = new ArrayList();
    protected Map index = new HashMap();
    protected Map fileIndex = new HashMap();

    public ExtendedLoader(ClassLoader classLoader, File file) throws Exception {
        super(classLoader);
        this.myDomain = this.getClass().getProtectionDomain();
        this.initializeSkeletonIndex(file);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (this.index.containsKey(string) && !this.skeletonIndex.contains(string)) {
            Class clazz = this.findClass(string);
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return super.loadClass(string, bl);
    }

    public URL getResource(String string) {
        if (this.index.containsKey(string) && !this.skeletonIndex.contains(string)) {
            URL uRL = this.findResource(string);
            return uRL;
        }
        return super.getResource(string);
    }

    public InputStream getResourceAsStream(String string) {
        if (this.index.containsKey(string) && !this.skeletonIndex.contains(string)) {
            return this.findResourceAsStream(string);
        }
        return super.getResourceAsStream(string);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        byte[] byArray = this.loadClassData(string);
        return this.defineClass(string, byArray, 0, byArray.length, this.myDomain);
    }

    protected URL findResource(String string) {
        JarEntry jarEntry = (JarEntry)this.index.get(string);
        if (jarEntry == null) {
            throw new RuntimeException("Resource not found: " + string);
        }
        try {
            JarFile jarFile = (JarFile)this.fileIndex.get(jarEntry);
            String string2 = "jar:file:" + jarFile.getName() + "!/" + jarEntry.getName();
            URL uRL = new URL(string2);
            return uRL;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throw new RuntimeException("Unable to load resource <" + string + "> due to following error", throwable);
        }
    }

    protected InputStream findResourceAsStream(String string) {
        JarEntry jarEntry = (JarEntry)this.index.get(string);
        if (jarEntry == null) {
            throw new RuntimeException("Resource not found: " + string);
        }
        try {
            JarFile jarFile = (JarFile)this.fileIndex.get(jarEntry);
            return jarFile.getInputStream(jarEntry);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throw new RuntimeException("Unable to load resource <" + string + "> due to following error", throwable);
        }
    }

    protected byte[] loadClassData(String string) throws ClassNotFoundException {
        JarEntry jarEntry = (JarEntry)this.index.get(string);
        if (jarEntry == null) {
            throw new ClassNotFoundException("Unknown class: <" + string + ">");
        }
        try {
            int n;
            int n2 = (int)jarEntry.getSize();
            byte[] byArray = new byte[n2];
            JarFile jarFile = (JarFile)this.fileIndex.get(jarEntry);
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            int n3 = 0;
            for (int i = 0; i < n2; i += n) {
                n = inputStream.read(byArray, i, n2 - i);
                if (++n3 <= 1) continue;
            }
            inputStream.close();
            return byArray;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throw new ClassNotFoundException("Unable to load class <" + string + "> due to following error", throwable);
        }
    }

    public void addFile(String string) throws Exception {
        this.addFile(new JarFile(string));
    }

    public void addFile(File file) throws Exception {
        this.addFile(new JarFile(file));
    }

    public void addFile(JarFile jarFile) throws Exception {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            if (string.endsWith(".class")) {
                String string2 = string.replaceAll("\\.class", "");
                if (this.index.containsKey(string2 = string2.replaceAll("/", "."))) continue;
                this.index.put(string2, jarEntry);
                this.fileIndex.put(jarEntry, jarFile);
                continue;
            }
            if (this.index.containsKey(string)) continue;
            this.index.put(string, jarEntry);
            this.fileIndex.put(jarEntry, jarFile);
        }
    }

    protected void initializeSkeletonIndex(File file) throws Exception {
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            if (string.endsWith(".class")) {
                String string2 = string.replaceAll("\\.class", "");
                string2 = string2.replaceAll("/", ".");
                this.skeletonIndex.add(string2);
                continue;
            }
            this.skeletonIndex.add(string);
        }
    }
}

